import 'package:freezed_annotation/freezed_annotation.dart';
import '../../domain/models/models.dart';

part 'comments_state.freezed.dart';

@freezed
class CommentsState with _$CommentsState {
  const factory CommentsState({
    @Default(false) bool isLoading,
    @Default([]) List<CommentsData> productComments,
    @Default([]) List<CommentsData> shopComments,
    @Default(1) int activeIndex,
    @Default(0) int stateIndex,
    @Default(-1) int selectedProductComment,
    @Default(-1) int selectedShopComment,
    @Default(true) bool hasMoreShopComment,
    @Default(true) bool hasMoreProductComment,
    @Default(false) isAllSelectProduct,
    @Default(false) isAllSelectShop,
    @Default([]) List<int> selectedProductIds,
    @Default([]) List<int> selectedShopIds,
    @Default(false) bool hasMoreLoading,
  }) = _CommentsState;

  const CommentsState._();
}
